import { getApiBaseUrl } from "@/lib/api/base-url";

export const getAllSubCategories = async () => {
  const url = `${getApiBaseUrl()}/subcategories`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<SubCategory[]> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching subcategories:", error);
    throw error;
  }
};

export const getSubCategoriesByCategory = async (categoryUuid: string) => {
  const url = `${getApiBaseUrl()}/subcategories/category/${categoryUuid}`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<SubCategory[]> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching subcategories by category:", error);
    throw error;
  }
};

export const getSubCategoryById = async (subcategoryUuid: string) => {
  const url = `${getApiBaseUrl()}/subcategories/${subcategoryUuid}`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });

    if (response.status === 404) {
      return null;
    }

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<SubCategory> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching subcategory:", error);
    throw error;
  }
};
