import { getApiBaseUrl } from "@/lib/api/base-url";

interface getCategoryResponse {
  data: Category;
}

// Categories API
export const getAllCategories = async () => {
  const url = `${getApiBaseUrl()}/categories`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<Category[]> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching categories:", error);
    throw error;
  }
};

export const getCategoryById = async (categoryUuid: string) => {
  const url = `${getApiBaseUrl()}/categories/${categoryUuid}`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<getCategoryResponse> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching category:", error);
    throw error;
  }
};

export const getAllCategoriesServer = async () => {
  const url = `${getApiBaseUrl()}/categories`;

  try {
    const response = await fetch(url, {
      cache: "no-store",
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const payload: APIResponse<Category[]> = await response.json();

    if (!("data" in payload)) {
      throw new Error(payload.message || "Unknown error occurred");
    }

    return payload;
  } catch (error) {
    console.error("Error fetching categories:", error);
    throw error;
  }
};
