export const getApiBaseUrl = () => {
  const baseUrl =
    process.env.API ||
    process.env.NEXT_PUBLIC_API ||
    process.env.NEXT_PUBLIC_API_BASE_URL ||
    process.env.API_BASE_URL ||
    "";

  if (!baseUrl) {
    throw new Error(
      "API base URL is not configured. Set API, NEXT_PUBLIC_API, or NEXT_PUBLIC_API_BASE_URL."
    );
  }

  return baseUrl.replace(/\/$/, "");
};
