
import React from 'react';

interface ShareIconProps {
  color?: string;
  width?: number;
  height?: number;
}

const ShareIcon: React.FC<ShareIconProps> = ({
  color = 'white',
  width = 46,
  height = 46,
}) => {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 46 46"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_3603_334)">
        <path
          d="M37.9805 31.4941C36.8086 31.4941 35.7319 31.7505 34.7505 32.2632C33.769 32.7759 32.9707 33.4717 32.3555 34.3506L13.8105 24.9023C13.8984 24.6094 13.9644 24.3091 14.0083 24.0015C14.0522 23.6938 14.0742 23.3789 14.0742 23.0566C14.0742 22.6465 14.0376 22.251 13.9644 21.8701C13.8911 21.4893 13.7959 21.123 13.6787 20.7715L32.3115 11.7188C32.9561 12.5977 33.769 13.3008 34.7505 13.8281C35.7319 14.3555 36.8086 14.6191 37.9805 14.6191C39.9141 14.6191 41.5693 13.9307 42.9463 12.5537C44.3232 11.1768 45.0117 9.52148 45.0117 7.58789C45.0117 5.6543 44.3232 3.99902 42.9463 2.62207C41.5693 1.24512 39.9141 0.556641 37.9805 0.556641C36.0469 0.556641 34.3916 1.24512 33.0146 2.62207C31.6377 3.99902 30.9492 5.6543 30.9492 7.58789C30.9492 7.85156 30.9639 8.11523 30.9932 8.37891C31.0225 8.64258 31.0664 8.90625 31.125 9.16992L12.2285 18.3545C11.584 17.6221 10.8149 17.0508 9.92139 16.6406C9.02783 16.2305 8.06836 16.0254 7.04297 16.0254C5.10938 16.0254 3.4541 16.7139 2.07715 18.0908C0.700195 19.4678 0.0117188 21.123 0.0117188 23.0566C0.0117188 24.9902 0.700195 26.6455 2.07715 28.0225C3.4541 29.3994 5.10938 30.0879 7.04297 30.0879C8.15625 30.0879 9.18896 29.8462 10.1411 29.3628C11.0933 28.8794 11.8916 28.2275 12.5361 27.4072L31.1689 36.8994C31.0811 37.1631 31.0225 37.4268 30.9932 37.6904C30.9639 37.9541 30.9492 38.2324 30.9492 38.5254C30.9492 40.459 31.6377 42.1143 33.0146 43.4912C34.3916 44.8682 36.0469 45.5566 37.9805 45.5566C39.9141 45.5566 41.5693 44.8682 42.9463 43.4912C44.3232 42.1143 45.0117 40.459 45.0117 38.5254C45.0117 36.5918 44.3232 34.9365 42.9463 33.5596C41.5693 32.1826 39.9141 31.4941 37.9805 31.4941ZM37.9805 3.36914C39.1523 3.36914 40.1484 3.7793 40.9688 4.59961C41.7891 5.41992 42.1992 6.41602 42.1992 7.58789C42.1992 8.75977 41.7891 9.75586 40.9688 10.5762C40.1484 11.3965 39.1523 11.8066 37.9805 11.8066C36.8086 11.8066 35.8125 11.3965 34.9922 10.5762C34.1719 9.75586 33.7617 8.75977 33.7617 7.58789C33.7617 6.41602 34.1719 5.41992 34.9922 4.59961C35.8125 3.7793 36.8086 3.36914 37.9805 3.36914ZM7.04297 27.2754C5.87109 27.2754 4.875 26.8652 4.05469 26.0449C3.23438 25.2246 2.82422 24.2285 2.82422 23.0566C2.82422 21.8848 3.23438 20.8887 4.05469 20.0684C4.875 19.248 5.87109 18.8379 7.04297 18.8379C8.21484 18.8379 9.21094 19.248 10.0312 20.0684C10.8516 20.8887 11.2617 21.8848 11.2617 23.0566C11.2617 24.2285 10.8516 25.2246 10.0312 26.0449C9.21094 26.8652 8.21484 27.2754 7.04297 27.2754ZM37.9805 42.7441C36.8086 42.7441 35.8125 42.334 34.9922 41.5137C34.1719 40.6934 33.7617 39.6973 33.7617 38.5254C33.7617 37.3535 34.1719 36.3574 34.9922 35.5371C35.8125 34.7168 36.8086 34.3066 37.9805 34.3066C39.1523 34.3066 40.1484 34.7168 40.9688 35.5371C41.7891 36.3574 42.1992 37.3535 42.1992 38.5254C42.1992 39.6973 41.7891 40.6934 40.9688 41.5137C40.1484 42.334 39.1523 42.7441 37.9805 42.7441Z"
          fill={color}
        />
      </g>
      <defs>
        <clipPath id="clip0_3603_334">
          <rect
            width="45"
            height="45"
            fill="white"
            transform="matrix(1 0 0 -1 0.0117188 45.5566)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};

export default ShareIcon;
