import React from 'react';

interface PasteIconProps {
  color?: string;
  width?: number;
  height?: number;
}

const PasteIcon: React.FC<PasteIconProps> = ({
  color = 'white',
  width = 40,
  height = 46,
}) => {
  return (
    <svg 
      width={width} 
      height={height} 
      viewBox="0 0 40 46" 
      fill="none" 
      xmlns="http://www.w3.org/2000/svg"
    >
      <mask id="path-1-inside-1_3603_328" fill="white">
        <path d="M19.6992 18.3345H29.6992V27.3345H19.6992V18.3345Z" />
        <path d="M28.1367 39.9316V43.4473C28.1367 44.6123 27.1923 45.5566 26.0273 45.5566H2.12109C0.956104 45.5566 0.0117188 44.6123 0.0117188 43.4473V11.1035C0.0117188 9.93853 0.956104 8.99414 2.12109 8.99414H8.44922V35.0098C8.44922 37.7237 10.6571 39.9316 13.3711 39.9316H28.1367ZM28.1367 9.69727V0.556641H13.3711C12.2061 0.556641 11.2617 1.50103 11.2617 2.66602V35.0098C11.2617 36.1748 12.2061 37.1191 13.3711 37.1191H37.2773C38.4423 37.1191 39.3867 36.1748 39.3867 35.0098V11.8066H30.2461C29.0859 11.8066 28.1367 10.8574 28.1367 9.69727ZM38.7689 6.97011L32.9733 1.17442C32.5777 0.778865 32.0412 0.556644 31.4817 0.556641H30.9492V8.99414H39.3867V8.46161C39.3867 7.90219 39.1645 7.36569 38.7689 6.97011Z" />
      </mask>
      <path 
        d="M19.6992 18.3345V7.33447H8.69922V18.3345H19.6992ZM29.6992 18.3345H40.6992V7.33447H29.6992V18.3345ZM29.6992 27.3345V38.3345H40.6992V27.3345H29.6992ZM19.6992 27.3345H8.69922V38.3345H19.6992V27.3345ZM28.1367 39.9316H39.1367V28.9316H28.1367V39.9316ZM8.44922 8.99414H19.4492V-2.00586H8.44922V8.99414ZM28.1367 0.556641H39.1367V-10.4434H28.1367V0.556641ZM39.3867 11.8066H50.3867V0.806641H39.3867V11.8066ZM38.7689 6.97011L46.5473 -0.807867L46.5471 -0.808068L38.7689 6.97011ZM32.9733 1.17442L40.7514 -6.60375L40.7512 -6.60395L32.9733 1.17442ZM31.4817 0.556641L31.4818 -10.4434H31.4817V0.556641ZM30.9492 0.556641V-10.4434H19.9492V0.556641H30.9492ZM30.9492 8.99414H19.9492V19.9941H30.9492V8.99414ZM39.3867 8.99414V19.9941H50.3867V8.99414H39.3867ZM39.3867 8.46161H50.3867V8.46155L39.3867 8.46161ZM19.6992 29.3345H29.6992V7.33447H19.6992V29.3345ZM18.6992 18.3345V27.3345H40.6992V18.3345H18.6992ZM29.6992 16.3345H19.6992V38.3345H29.6992V16.3345ZM30.6992 27.3345V18.3345H8.69922V27.3345H30.6992ZM17.1367 39.9316V43.4473H39.1367V39.9316H17.1367ZM17.1367 43.4473C17.1367 38.5371 21.1172 34.5566 26.0273 34.5566V56.5566C33.2675 56.5566 39.1367 50.6874 39.1367 43.4473H17.1367ZM26.0273 34.5566H2.12109V56.5566H26.0273V34.5566ZM2.12109 34.5566C7.03124 34.5566 11.0117 38.5371 11.0117 43.4473H-10.9883C-10.9883 50.6874 -5.11903 56.5566 2.12109 56.5566V34.5566ZM11.0117 43.4473V11.1035H-10.9883V43.4473H11.0117ZM11.0117 11.1035C11.0117 16.0137 7.03124 19.9941 2.12109 19.9941V-2.00586C-5.11903 -2.00586 -10.9883 3.86339 -10.9883 11.1035H11.0117ZM2.12109 19.9941H8.44922V-2.00586H2.12109V19.9941ZM-2.55078 8.99414V35.0098H19.4492V8.99414H-2.55078ZM-2.55078 35.0098C-2.55078 43.7989 4.58199 50.9316 13.3711 50.9316V28.9316C16.7323 28.9316 19.4492 31.6486 19.4492 35.0098H-2.55078ZM13.3711 50.9316H28.1367V28.9316H13.3711V50.9316ZM39.1367 9.69727V0.556641H17.1367V9.69727H39.1367ZM28.1367 -10.4434H13.3711V11.5566H28.1367V-10.4434ZM13.3711 -10.4434C6.13097 -10.4434 0.261719 -4.57411 0.261719 2.66602H22.2617C22.2617 7.57616 18.2812 11.5566 13.3711 11.5566V-10.4434ZM0.261719 2.66602V35.0098H22.2617V2.66602H0.261719ZM0.261719 35.0098C0.261719 42.2499 6.13097 48.1191 13.3711 48.1191V26.1191C18.2812 26.1191 22.2617 30.0996 22.2617 35.0098H0.261719ZM13.3711 48.1191H37.2773V26.1191H13.3711V48.1191ZM37.2773 48.1191C44.5175 48.1191 50.3867 42.2499 50.3867 35.0098H28.3867C28.3867 30.0996 32.3672 26.1191 37.2773 26.1191V48.1191ZM50.3867 35.0098V11.8066H28.3867V35.0098H50.3867ZM39.3867 0.806641H30.2461V22.8066H39.3867V0.806641ZM30.2461 0.806641C35.1611 0.806641 39.1367 4.78229 39.1367 9.69727H17.1367C17.1367 16.9326 23.0108 22.8066 30.2461 22.8066V0.806641ZM46.5471 -0.808068L40.7514 -6.60375L25.1951 8.9526L30.9908 14.7483L46.5471 -0.808068ZM40.7512 -6.60395C38.2928 -9.06228 34.9585 -10.4433 31.4818 -10.4434L31.4817 11.5566C29.1238 11.5566 26.8626 10.62 25.1953 8.9528L40.7512 -6.60395ZM31.4817 -10.4434H30.9492V11.5566H31.4817V-10.4434ZM19.9492 0.556641V8.99414H41.9492V0.556641H19.9492ZM30.9492 19.9941H39.3867V-2.00586H30.9492V19.9941ZM50.3867 8.99414V8.46161H28.3867V8.99414H50.3867ZM50.3867 8.46155C50.3867 4.98488 49.0056 1.65059 46.5473 -0.807867L30.9906 14.7481C29.3234 13.0808 28.3867 10.8195 28.3867 8.46167L50.3867 8.46155Z" 
        fill={color} 
        mask="url(#path-1-inside-1_3603_328)"
      />
    </svg>
  );
};

export default PasteIcon;