/** @type {import('next').NextConfig} */
const nextConfig = {
  devIndicators: false,
  images: {
    formats: ["image/webp", "image/avif"],
    deviceSizes: [640, 750, 828, 1080, 1200, 1920, 2048, 3840],
    remotePatterns: [
      {
        protocol: "https",
        hostname: "dashboard.dirbal.ly",
      },
    ],
  },
  compress: true,
  optimizeFonts: true,
  output: "standalone",
};

module.exports = nextConfig;
