# Accessibility Button - دليل الاستخدام

## الميزات Features

### 1. زر إمكانية الوصول Accessibility Button

- يظهر في أسفل **يسار** كل صفحة
- لون أزرق مع أيقونة سهم
- يفتح عند النقر عليه
- **يتم إعادة تعيين الإعدادات تلقائياً عند الانتقال بين الصفحات**

### 2. زر العودة لأعلى Scroll to Top Button

- يظهر في أسفل **يمين** كل صفحة
- لون رمادي مع أيقونة سهم لأعلى
- يظهر فقط عند التمرير لأسفل (أكثر من 300px)
- يؤدي إلى العودة لأعلى الصفحة بتمرير سلس

### 3. التحكم في حجم الخط Font Size Control

- **نظام نسبي**: يزيد/ينقص من الأحجام الموجودة بدلاً من استبدالها
- **A+**: زيادة حجم الخط بنسبة 10%
- **A-**: تقليل حجم الخط بنسبة 10%
- **النطاق**: من 50% إلى 200% من الحجم الأصلي
- **إعادة تعيين تلقائية**: عند الانتقال لأي صفحة جديدة

#### كيف يعمل How it works:

- إذا كان لديك نص `text-lg` (كبير) وضغطت A+، سيصبح أكبر
- إذا كان لديك نص `text-sm` (صغير) وضغطت A+، سيصبح أكبر أيضاً
- يحافظ على النسب النسبية بين أحجام النصوص المختلفة
- **عند الانتقال لصفحة جديدة، تعود جميع الإعدادات للقيم الافتراضية**

### 4. وضع قارئ الشاشة Screen Reader Mode

- **تشغيل**: يضيف مؤشرات التركيز والخصائص المساعدة
- **إيقاف**: يعيد الإعدادات إلى وضعها الطبيعي
- **إعلانات**: يعلن عن التغييرات لقارئ الشاشة
- **إعادة تعيين تلقائية**: عند الانتقال لأي صفحة جديدة

### 5. زر إعادة التعيين Reset Button

- يعيد جميع الإعدادات إلى القيم الافتراضية
- يزيل أحجام الخطوط المخصصة
- يعيد أحجام الخطوط الأصلية

## التقنيات المستخدمة Technologies Used

- **React 19** مع TypeScript
- **Tailwind CSS** للتصميم
- **Lucide React** للأيقونات
- **Next.js Router Events** لتتبع تغيير الصفحات
- **CSS Custom Properties** للمتغيرات
- **Window Scroll Events** لزر العودة لأعلى

## التثبيت Installation

1. تم إضافة الزر تلقائياً إلى `src/app/layout.tsx`
2. يظهر على جميع صفحات الموقع
3. **يتم إعادة تعيين الإعدادات تلقائياً عند كل تنقل بين الصفحات**
4. لا يحتاج إلى إعدادات إضافية

## الاستخدام Usage

### للمطورين For Developers

```tsx
import AccessibilityWrapper from "@/components/accessibility-wrapper";
import ScrollToTopButton from "@/components/scroll-to-top-button";

// إضافة الزر إلى أي صفحة مع إعادة تعيين تلقائية
<AccessibilityWrapper />
<ScrollToTopButton />
```

### للمستخدمين For Users

1. **النقر على الزر الأزرق** في أسفل يسار الصفحة (إمكانية الوصول)
2. **اختيار حجم الخط**:
   - A+ لزيادة الحجم
   - A- لتقليل الحجم
3. **تفعيل وضع قارئ الشاشة** إذا لزم الأمر
4. **إعادة التعيين** عند الحاجة
5. **إعادة تعيين تلقائية** عند الانتقال لصفحة جديدة
6. **النقر على الزر الرمادي** في أسفل يمين الصفحة للعودة لأعلى

## الملفات Files

- `src/components/accessibility-button.tsx` - المكون الرئيسي لإمكانية الوصول
- `src/components/accessibility-wrapper.tsx` - الغلاف مع إعادة التعيين التلقائية
- `src/components/scroll-to-top-button.tsx` - زر العودة لأعلى
- `src/lib/hooks/useAccessibilityReset.ts` - Hook لإعادة التعيين التلقائية
- `src/app/layout.tsx` - التخطيط الرئيسي
- `src/app/globals.css` - الأنماط العامة

## الدعم Support

- يعمل مع جميع المتصفحات الحديثة
- يدعم اللغة العربية (RTL)
- متوافق مع معايير إمكانية الوصول WCAG
- يدعم وضع التباين العالي
- يدعم تقليل الحركة
- **إعادة تعيين تلقائية لكل صفحة جديدة**
- **زر العودة لأعلى مع تمرير سلس**
